<%

	' This script gets data from Array and
	' puts it into AnyChart XML format
	' this script is used in index.html file
	' to show chart using AnyChart.

	' set XML as output format for this script.

        Response.ContentType = "text/xml"

	Dim products(2,1)

	products(0,0)  = "Product A"
	products(0,1) = 10000	

	products(1,0)  = "Product B"
	products(1,1) = 20000	

	products(2,0)  = "Product C"
	products(2,1) = 50000	

	' Create a string with data section
	data = "<data>"

		' Open series node 
		data = data & "<series name='Products Report'>"

			For i = 0 to UBound(products)

				data = 	data & "<point name='" & products(i,0) & "' y='" & products(i,1) & "' />"

			Next

		' Close series node
		data = data & "</series>"  

	' Close data node
	data = data & "</data>"


' Chart Settings XML
%><anychart>
	<charts>
		<chart>
			<chart_settings>
			  <title>
				<text>Products Sales Volume by Products</text>
			  </title>
			  <axes>
			  	<x_axis>
			  		<title>
			  			<text>Product Name</text>
			  		</title>
			  	</x_axis>
			  	<y_axis>
			  		<title>
			  			<text>Volume</text>
			  		</title>
			  		<labels>
			  			<format>{%Value} $</format>
			  		</labels>
			  	</y_axis>
			  </axes>
			</chart_settings>
			<data_plot_settings>
				<bar_series>
					<tooltip_settings enabled="true">
						<format><![CDATA[{%Name}{enabled:false}
Volume: {%YValue}$]]> </format>
					</tooltip_settings>
				</bar_series>
			</data_plot_settings>

			<%
		
			' Output data section

			Response.Write data 

			%>

		</chart>
	</charts>
</anychart>
