<% 

	' This script gets data from MS SQL Database and
	' puts it into AnyChart XML format
	' this script is used in index.html file
	' to show chart using AnyChart.

	' set XML as output format for this script.

        Response.ContentType = "text/xml"

	' configure connection to your database
	' data from dump.sql should be added to
	' your database in order for this sample
	' to work 



	Dim ConnectionString ' SQLServer Connection string
	Dim cn ' SQLServer Connection object

	' Form a connection string
	' Choose ODBC or DSN connection and replace SERVER_NAME, UID, PWD and DB_NAME with real values
	' in order sample to work - execute dump.sql in the database where you created tables

	'ConnectionString = "driver={SQLServer};server=SERVER_NAME;uid=UID;pwd=PWD;database=DB_NAME" '## MS SQL Server 6.x/7.x/2000 (ODBC connection)

	' Create and open a connection
	set cn = Server.CreateObject("ADODB.Connection")
	cn.Open ConnectionString

	' Create RecordSet object
	Set productsRS = Server.CreateObject("ADODB.Recordset")

	' Form SQL command
	' Select all products from anychart_sample_products
	productsQuery = "SELECT * FROM anychart_sample_products"

	' Execute query into RecordSet
	productsRS.Open productsQuery, cn

	' Create a string with data section
	data = "<data>"

	
	' Loop through records until the end of RecordSet
	while not productsRS.eof


		' Open series node 
		data =  data & "<series name='" & trim(productsRS("name")) & "'>"
		product_id =  productsRS("product_id")

		ordersQuery = "SELECT sum(volume) as total, order_date FROM anychart_sample_orders WHERE product_id=" & product_id & " GROUP BY order_date ORDER BY order_date ASC"

		' Create RecordSet object
		Set ordersRS = Server.CreateObject("ADODB.Recordset")

		' Execute query into RecordSet
		ordersRS.Open ordersQuery, cn

		while not ordersRS.eof

		  	data = data & "<point name='" & ordersRS("order_date") & "' y='" & ordersRS("total") & "' />"
			ordersRS.movenext

			
		wend

		data =  data & "</series>"
		productsRS.movenext

	wend

	data = data & "</data>"

	cn.close

	' Note: the same idea can be used for 
	' connecting with any other database.


' Chart Settings XML
%><anychart>
	<charts>
		<chart >
			<chart_settings>
			  <title>
				<text>Products orders by date</text>
			  </title>
			  <legend enabled="true">
			  	<title enabled="false" />
			  	<title_separator enabled="false" />
			  </legend>
			  <axes>
			  	<x_axis>
			  		<title>
			  			<text>Date</text>
			  		</title>
			  	</x_axis>
			  	<y_axis>
			  		<title>
			  			<text>Volume</text>
			  		</title>
			  		<labels>
			  			<format>{%Value} $</format>
			  		</labels>
			  	</y_axis>
			  </axes>
			</chart_settings>
			<data_plot_settings>
				<bar_series>
					<tooltip_settings enabled="true">
						<format><![CDATA[Product: {%SeriesName}{enabled:false}
Date: {%Name}{enabled:false}
Volume: {%YValue}$]]> </format>
					</tooltip_settings>
				</bar_series>
			</data_plot_settings>

<%

' Output data section

Response.Write data

%>

		</chart>
	</charts>
</anychart>