<% 

        Response.ContentType = "text/xml"


	' This script creates XML
	' used to create Map chart
	' in index.html

	map_file = "states.amap"


	' Create new series
	regions = "<series palette='Default' type='MapRegions'>" & _
			"<actions>" & _
				"<action type='call' function='alert'>" & _
					"<arg>{%REGION_NAME} is clicked</arg>" & _
				"</action>" & _
			"</actions>" & _
			"<tooltip enabled='true'>" & _
				"<format>{%Value}</format>" & _
			"</tooltip>" & _
			"<label enabled='true'>" & _
				"<format>{%Name}</format>" & _
			"</label>"

	alaska  = "<point name='AK' y='10'/>"
	alabama = "<point name='AL' y='20'/>"
	arkansas= "<point name='AR' y='40'>" & _
			"<tooltip>" & _
				"<format>Arkansas shares a border with six states.</format>" & _
			"</tooltip>" & _
		    "</point>"

        regions = regions & alaska  & alabama  & arkansas  &  "</series>"


	dim cities(2,2)

	cities(0,0) = "San Francisco"
	cities(0,1) = "-122.433333"
	cities(0,2) = "37.766667"

	cities(1,0) = "Los Angeles"
	cities(1,1) = "-118.25"
	cities(1,2) = "34.05"

	cities(2,0) = "Denver"
	cities(2,1) = "-104.984"
	cities(2,2) = "39.739"

	' Create new series with points
	points =  "<series name='Cities' palette='Default' type='Marker'>" & _
			"<actions>" & _
				"<action type='navigateToUrl' url='http://en.wikipedia.org/wiki/{%Name}'/>" & _
			"</actions>" & _
			"<marker type='Circle'/>" & _
			"<tooltip enabled='true'>" & _
				"<format>Click to read about {%Name} on Wikipedia</format>" & _
			"</tooltip>" & _
			"<label enabled='true'>" & _
				"<format>{%Name}</format>" & _
			"</label>"

			for i = 0 to ubound(cities)

			  	points = points & "<point name='" & cities(i,0) & "' x='" & cities(i,1) & "' y='" & cities(i,2) & "' />"
	
			next

        points = points &  "</series>"

	data =  regions & points

%>
    
<anychart>
	<margin all="2"/>
		<charts>
			<chart plot_type="map">
				<data_plot_settings>
<% 
	' map file is set here it is stored in maps anychart_files/swf/maps
	' AnyChart package contains more than 300 of other maps
	' and AnyChart team can create custom maps for you
	' please refer to AnyChart Documentation for more

%>

<map_series source="<%=map_file%>"/>
				</data_plot_settings>
				<data>
<%
		
	' Output data section
	Response.write data

%>

				</data>
				<chart_settings>
					<title><text><![CDATA[Sample Map of the USA]]></text></title>
					<chart_background><corners type="Square"/></chart_background>
					<data_plot_background><inside_margin all="2"/></data_plot_background>
				</chart_settings>
			</chart>
		</charts>
</anychart>
