<%@ Page Language="C#" %>

<%

	/*
	 This script gets data from Array and
	 puts it into AnyChart XML format
	 this script is used in index.html file
	 to show chart using AnyChart. 

	 set XML as output format for this script.
    */
    Response.ContentType = "text/xml";

	
	string[] productNames = {"Product A", "Product B", "Product C"};
    int[] productSales = {10000,20000,50000};
    
    String data;
    
	// Create a string with data section
	data = "<data>";

		// Open series node 
		data = data + "<series name='Products Report'>";
            
			for (int i = 0; i < productNames.Length; i++)
            {
                data = data + "<point name='" + productNames[i] + "' y='" + productSales[i] + "' />";
            }

		// Close series node
        
		data = data + "</series>";

	// Close data node
	data = data + "</data>";


// Chart Settings XML
%>
<anychart>
	<charts>
		<chart>
			<chart_settings>
			  <title>
				<text>Products Sales Volume by Products</text>
			  </title>
			  <axes>
			  	<x_axis>
			  		<title>
			  			<text>Product Name</text>
			  		</title>
			  	</x_axis>
			  	<y_axis>
			  		<title>
			  			<text>Volume</text>
			  		</title>
			  		<labels>
			  			<format>{%Value} $</format>
			  		</labels>
			  	</y_axis>
			  </axes>
			</chart_settings>
			<data_plot_settings>
				<bar_series>
					<tooltip_settings enabled="true">
						<format><![CDATA[{%Name}{enabled:false}
Volume: {%YValue}$]]> </format>
					</tooltip_settings>
				</bar_series>
			</data_plot_settings>

			<%
		
			// Output data section

			Response.Write(data);

			%>

		</chart>
	</charts>
</anychart>
