<%@ Page Language="C#" %>
<%@ Import Namespace="System.Data.OleDb" %>

<% 
    
	/*
      This script gets data from MS SQL Database and
	 puts it into AnyChart XML format
	 this script is used in index.html file
	 to show chart using AnyChart.
     */

	// set XML as output format for this script.

        Response.ContentType = "text/xml";

	/*
      configure connection to your database
	 data from dump.sql should be added to
	 your database in order for this sample
	 to work 
     */


    
    // OleDbConnection Connection object
    // Paste your connection details
    OleDbConnection  cnProducts = new OleDbConnection(
                             "provider=sqloledb;" + 
                             "Data Source=(local);" + 
                             "Database=vanitas;" +
                             "User Id=sa;" +
                             "Password=1;"
                             );

    // Open the connection
    cnProducts.Open();


    // OleDbConnection Connection object
    // Paste your connection details
    OleDbConnection cnOrders = new OleDbConnection(
                             "provider=sqloledb;" +
                             "Data Source=(local);" +
                             "Database=vanitas;" +
                             "User Id=sa;" +
                             "Password=1;"
                             );

    // Open the connection
    cnOrders.Open();
        
	// Create RecordSet object
	OleDbDataReader productsReader;
    
	// Form SQL command
	// Select all products from anychart_sample_products
	String productsQuery = "SELECT product_id, name FROM anychart_sample_products";

    OleDbCommand commandProducts = new OleDbCommand(productsQuery, cnProducts);
    
	// Execute query into RecordSet
    productsReader = commandProducts.ExecuteReader();

	// Create a string with data section
	String data = "<data>";
    OleDbDataReader ordersReader;


	// Loop through records until the end of RecordSet
	while (productsReader.Read())
        {

            
                // Open series node 
        
                data =  data + "<series name='" + productsReader.GetString(1).Trim() + "'>";

                int product_id = productsReader.GetInt32(0);

                string ordersQuery = "SELECT sum(volume) as total, order_date FROM anychart_sample_orders WHERE product_id=" + product_id.ToString() + " GROUP BY order_date ORDER BY order_date ASC";
        
                                OleDbCommand commandOrders = new OleDbCommand(ordersQuery, cnOrders);
        
                                // Execute query into RecordSet
                                ordersReader = commandOrders.ExecuteReader();
        
                                while (ordersReader.Read())
                                {
                                    // Get Date for Points
                                    data = data + "<point name='" + ordersReader.GetDateTime(1).ToShortDateString() + "' y='" + ordersReader.GetInt32(0).ToString() + "' />";

                                }
        
                                ordersReader.Close();
                                
		data =  data + "</series>";

    }
 
    
    productsReader.Close();
    
    
	data = data + "</data>";

    cnProducts.Close();
    cnOrders.Close();

	// Note: the same idea can be used for 
	// connecting with any other database.


// Chart Settings XML
%><anychart>
	<charts>
		<chart >
			<chart_settings>
			  <title>
				<text>Products orders by date</text>
			  </title>
			  <legend enabled="true">
			  	<title enabled="false" />
			  	<title_separator enabled="false" />
			  </legend>
			  <axes>
			  	<x_axis>
			  		<title>
			  			<text>Date</text>
			  		</title>
			  	</x_axis>
			  	<y_axis>
			  		<title>
			  			<text>Volume</text>
			  		</title>
			  		<labels>
			  			<format>{%Value} $</format>
			  		</labels>
			  	</y_axis>
			  </axes>
			</chart_settings>
			<data_plot_settings>
				<bar_series>
					<tooltip_settings enabled="true">
						<format><![CDATA[Product: {%SeriesName}{enabled:false}
Date: {%Name}{enabled:false}
Volume: {%YValue}$]]> </format>
					</tooltip_settings>
				</bar_series>
			</data_plot_settings>

<%

// Output data section

Response.Write (data);

%>

		</chart>
	</charts>
</anychart>