if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_anychart_sample_orders_anychart_sample_products]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[anychart_sample_orders] DROP CONSTRAINT FK_anychart_sample_orders_anychart_sample_products
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[anychart_sample_orders]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[anychart_sample_orders]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[anychart_sample_products]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[anychart_sample_products]
GO

CREATE TABLE [dbo].[anychart_sample_orders] (
	[order_id] [int] NOT NULL ,
	[product_id] [int] NOT NULL ,
	[order_date] [datetime] NOT NULL ,
	[volume] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[anychart_sample_products] (
	[product_id] [int] NOT NULL ,
	[name] [char] (50) COLLATE Cyrillic_General_CI_AS NULL 
) ON [PRIMARY]
GO

INSERT INTO [dbo].[anychart_sample_products]([product_id], [name]) VALUES(1, 'Product A')
GO

INSERT INTO [dbo].[anychart_sample_products]([product_id], [name]) VALUES(2, 'Product B')
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(1,1,'2008-07-09', 120)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(2,1,'2008-07-09', 230)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(3,1,'2008-06-09', 160)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(4,1,'2008-06-09', 540)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(5,1,'2008-06-01', 110)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(6,2,'2008-07-09', 130)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(7,2,'2008-07-09', 250)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(8,2,'2008-06-09', 320)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(9,2,'2008-06-09', 420)
GO

INSERT INTO [dbo].[anychart_sample_orders]([order_id], [product_id], [order_date], [volume]) VALUES(10,2,'2008-06-01',320)
GO

ALTER TABLE [dbo].[anychart_sample_orders] ADD 
	CONSTRAINT [PK_anychart_sample_orders] PRIMARY KEY  CLUSTERED 
	(
		[order_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[anychart_sample_products] ADD 
	CONSTRAINT [PK_anychart_sample_products] PRIMARY KEY  CLUSTERED 
	(
		[product_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[anychart_sample_orders] ADD 
	CONSTRAINT [FK_anychart_sample_orders_anychart_sample_products] FOREIGN KEY 
	(
		[product_id]
	) REFERENCES [dbo].[anychart_sample_products] (
		[product_id]
	)
GO

