<%@ Page Language="C#" %>

<% 

    Response.ContentType = "text/xml";


	/*
     This script creates XML
	 used to create Map chart
	 in index.html 
    */

	String map_file = "states.amap";
    

	// Create new series
	String regions = "<series palette='Default' type='MapRegions'>" +
			"<actions>" +
				"<action type='call' function='alert'>" +
					"<arg>{%REGION_NAME} is clicked</arg>" +
				"</action>" +
			"</actions>" +
			"<tooltip enabled='true'>" +
				"<format>{%Value}</format>" +
			"</tooltip>" +
			"<label enabled='true'>" +
				"<format>{%Name}</format>" +
			"</label>";

    String alaska = "<point name='AK' y='10'/>";
    String alabama = "<point name='AL' y='20'/>";
    String arkansas = "<point name='AR' y='40'>" +
			"<tooltip>" +
				"<format>Arkansas shares a border with six states.</format>" +
			"</tooltip>" +
		    "</point>";

        regions = regions + alaska  + alabama  + arkansas  +  "</series>";


	String[,] cities = {
                            { "San Francisco", "-122.433333", "37.766667"},
	                        { "Los Angeles", "-118.25", "34.05" },
                            { "Denver", "-104.984", "39.739"}
                        };

	// Create new series with points
    String points = "<series name='Cities' palette='Default' type='Marker'>" +
			"<actions>" +
				"<action type='navigateToUrl' url='http://en.wikipedia.org/wiki/{%Name}'/>" +
			"</actions>" +
			"<marker type='Circle'/>" +
			"<tooltip enabled='true'>" +
				"<format>Click to read about {%Name} on Wikipedia</format>" +
			"</tooltip>" +
			"<label enabled='true'>" +
				"<format>{%Name}</format>" +
			"</label>";

			for (int i = 0; i < 3; i++)
            {
			  	points = points + "<point name='" + cities[i,0] + "' x='" + cities[i,1] + "' y='" + cities[i,2] + "' />";
            }
        points = points +  "</series>";

	string data =  regions + points;

%>
    
<anychart>
	<margin all="2"/>
		<charts>
			<chart plot_type="map">
				<data_plot_settings>
<% 
	/* 
     map file is set here it is stored in maps anychart_files/swf/maps
	 AnyChart package contains more than 300 of other maps
	 and AnyChart team can create custom maps for you
	 please refer to AnyChart Documentation for more
     */

%>

<map_series source="<%Response.Write(map_file);%>"/>
				</data_plot_settings>
				<data>
<%
		
	// Output data section
    Response.Write(data);

%>

				</data>
				<chart_settings>
					<title><text><![CDATA[Sample Map of the USA]]></text></title>
					<chart_background><corners type="Square"/></chart_background>
					<data_plot_background><inside_margin all="2"/></data_plot_background>
				</chart_settings>
			</chart>
		</charts>
</anychart>
