package com.anychart;

/**
 * Flash movie WMode
 */
public class WMode {
    public static final WMode window = new WMode("window");
    public static final WMode opaque = new WMode("opaque");
    public static final WMode transparent = new WMode("transparent");
    
    private static WMode[] ALL = {window, opaque, transparent};
    
    private String mode;
    
    private WMode(String mode) {
    	this.mode = mode;
    }
    
    public String toString() {
    	return this.mode;
    }
    
    public static WMode fromString(String str) {
    	for (int i = 0; i < ALL.length; ++i) {
    		if (ALL[i].toString().equalsIgnoreCase(str)) {
    			return ALL[i];
    		}
    	}
    	return null;
    }
}
