package com.anychart.jsp;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

import com.anychart.AnyChart;
import com.anychart.WMode;

/**
 * Class implements the AnyChart JSP tag behavior
 *
 */
public class ChartTag extends BodyTagSupport {

	/**
	 * Chart count page attribute name
	 */
	private static final String CHART_COUNT_PANAME = AnyChart.IDENTITY_STRING + ".page_chart_count";
	
	
	/**
	 * field to store <i>width</i> attribute value
	 */
	private String width;
	
	/**
	 * field to store <i>height</i> attribute value
	 */
	private String height;
	
	/**
	 * field to store <i>bgColor</i> attribute value
	 */
	private String bgColor;
	
	/**
	 * field to store <i>wMode</i> attribute value
	 */
	private WMode wMode;
    
    /**
	 * field to store <i>xmlFile</i> attribute value
	 */
    private String xmlFile;
    
    /**
	 * field to store chart xml settings and data as string
	 */
    private String xmlData;
	/**
	 * 
	 */
	public ChartTag() {
		super();
	}

	/**
     * Gets component width
     *
     * @return chart width
     */
    public String getWidth() {
        return width;
    }

    /**
     * Sets chart width
     *
     * @param width chart width
     */
    public void setWidth(String width) {
        this.width = width;
    }

    /**
     * Gets chart height
     *
     * @return chart height
     */
    public String getHeight() {
        return height;
    }

    /**
     * Sets chart height
     *
     * @param height new height
     */
    public void setHeight(String height) {
        this.height = height;
    }

    /**
     * Gets chart flash movie background color
     *
     * @return background color
     */
    public String getBgColor() {
        return bgColor;
    }

    /**
     * Sets chart flash movie background color
     *
     * @param bgColor background color
     */
    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }
    
    /**
     * Gets wMode
     *
     * @return wmode
     */
    public String getWmode() {
        return this.wMode != null ? this.wMode.toString() : null;
    }

    /**
     * Sets wmode
     *
     * @param str set new wmode
     */
    public void setWmode(String str) {
        this.wMode = WMode.fromString(str);
    }

    /**
     * Gets anychart xml settings and data file path
     *
     * @return String http path
     */
    public String getXmlFile() {
        return xmlFile;
    }

    /**
     * Sets anychart xml settings and data file path
     *
     * @param xmlFile String http path
     */
    public void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

	/**
	 * 
	 * @see javax.servlet.jsp.tagext.BodyTagSupport#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		BodyContent bc = super.getBodyContent();
		if (bc != null) {
			this.xmlData = bc.getString();
			if (this.xmlData != null) {
				this.xmlData = this.xmlData.trim();
			}
			bc.clearBody();
		}
		return SKIP_BODY;
	}

	/**
	 * @see javax.servlet.jsp.tagext.BodyTagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		Object o = super.pageContext.getAttribute(CHART_COUNT_PANAME);
		int i = 0;
		if (o != null && o instanceof Integer) {
			i = ((Integer)o).intValue();
		}
		if (i == 0) {
			this.writePageInitJavaScript(AnyChart.JS_PATH, AnyChart.SWF_PATH);
		}
		this.writeComponentJavaScript("chart_" + ++i);
		super.pageContext.setAttribute(CHART_COUNT_PANAME, new Integer(i));
		
		return EVAL_PAGE;
	}

	/**
     * Write out Init JavaScript code for the first time tag appearance on JSP page 
     */
	private void writePageInitJavaScript(String jsPath, String swfPath) throws JspException {
		try {
			JspWriter w = super.pageContext.getOut();
			w.print("<script type=\"text/javascript\" language=\"javascript\" src=\"");
			w.print(jsPath);
			w.print("\"></script>\n");
			w.print("<script type=\"text/javascript\" language=\"javascript\">\n//<![CDATA[\n");
			w.print("\tAnyChart.swfFile=\"");
			w.print(swfPath);
			w.print("\";\n");
			w.print("//]]>\n</script>\n");
		} catch (IOException e) {
			throw new JspException(e);
		}
	}
	
	/**
     * Method writes HTML JavaScript code for AnyChart component creation
     * on client side
     *
     * @param jsObjectName - chart javascript variable name
     */
	private void writeComponentJavaScript(String jsObjectName) throws JspException {
		try {
			JspWriter w = super.pageContext.getOut();
			if (this.xmlData != null && this.xmlData.length() > 0) {
				//String formattedXMLData = this.xmlData.replace('\'','\"');
				w.print("<textarea id=\""); w.print(jsObjectName);
				w.print("_data\" cols=\"0\" rows=\"0\" style=\"display: none;\">\n");
				if (!this.xmlData.startsWith("<anychart")) {
					w.print("<anychart>\n");
				}
				w.print(this.xmlData);
				if (!this.xmlData.endsWith("anychart>")) {
					w.print("\n</anychart>\n");
				}
				w.print("</textarea>\n");
			}
			w.print("<script type=\"text/javascript\" language=\"javascript\">\n//<![CDATA[\n");
			w.print("\tvar "); w.print(jsObjectName); w.print(" = new AnyChart();\n\t");
			w.print(jsObjectName); w.print(".width='");
			w.print(this.width); w.print("';\n\t");
			w.print(jsObjectName); w.print(".height='");
			w.print(this.height); w.print("';\n");
			if (this.bgColor != null) {
				w.print("\t"); w.print(jsObjectName); w.print(".bgColor='");
				w.print(this.bgColor); w.print("';\n");
			}
			if (this.wMode != null) {
				w.print("\t"); w.print(jsObjectName); w.print(".wMode='");
				w.print(this.wMode.toString()); w.print("';\n");
			}
			if (this.xmlFile != null/* && this.xmlData == null*/) {
				w.print("\t"); w.print(jsObjectName); w.print(".setXMLFile('");
				w.print(this.xmlFile); w.print("');\n");
			}
			if (this.xmlData != null && this.xmlData.length() > 0) {
				w.print("\t"); w.print(jsObjectName); w.print(".setData(");
				w.print("document.getElementById('"); w.print(jsObjectName);
				w.print("_data').value.toString());\n");
			}
			w.print("\t"); w.print(jsObjectName); w.print(".write();\n");
			w.print("//]]>\n</script>\n");
		} catch (IOException e) {
			throw new JspException(e);
		}
	}

	/**
	 * @see javax.servlet.jsp.tagext.BodyTagSupport#release()
	 */
	public void release() {
		this.width = null;
		this.height = null;
		this.wMode = null;
		this.bgColor = null;
		this.xmlFile = null;
		this.xmlData = null;
		super.release();
	}
    
}
