package com.anychart.servlet;

import java.io.IOException;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.anychart.AnyChart;

/**
 * This class is intended for catching relative path request to
 * AnyChart static resource
 */
public class ResourceFilter implements Filter {

	

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig arg0) throws ServletException {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest req, ServletResponse resp,
			FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest)req;
		HttpServletResponse response = (HttpServletResponse)resp;
		String uri = request.getRequestURI();
		if (uri != null) {
			if (uri.endsWith(AnyChart.JS_PATH)) {
				this.writeResponseJS(response);
				return;
			}
			if (uri.endsWith(AnyChart.SWF_PATH)) {
				this.writeResponseSWF(response);
				return;
			}
		}
		chain.doFilter(req, resp);
	}
	
	/**
	 * Method writes JS content to {@link HttpServletResponse}
	 * @param response
	 * @throws IOException
	 */
	private void writeResponseJS(HttpServletResponse response) throws IOException {
		AnyChart data = AnyChart.getInstance();
		response.setContentType("text/javascript");
		response.setDateHeader("Last-Modified", data.getJs().getLastModified());
		data.getJs().writeContent(response.getOutputStream());
	}

	/**
	 * Method writes SWF content to {@link HttpServletResponse}
	 * @param response
	 * @throws IOException
	 */
	private void writeResponseSWF(HttpServletResponse response) throws IOException {
		AnyChart data = AnyChart.getInstance();
		response.setContentType("application/x-shockwave-flash");
		response.setDateHeader("Last-Modified", data.getSwf().getLastModified());
		data.getSwf().writeContent(response.getOutputStream());
	}
}
