/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.jsp;

import com.anychart.WMode;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ChartTag
extends BodyTagSupport {
    private static final String CHART_COUNT_PANAME = "com/anychart/chart_4.2.1.page_chart_count";
    private String width;
    private String height;
    private String bgColor;
    private WMode wMode;
    private String xmlFile;
    private String xmlData;

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String getWmode() {
        return this.wMode != null ? this.wMode.toString() : null;
    }

    public void setWmode(String str) {
        this.wMode = WMode.fromString(str);
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public int doAfterBody() throws JspException {
        BodyContent bc = super.getBodyContent();
        if (bc != null) {
            this.xmlData = bc.getString();
            if (this.xmlData != null) {
                this.xmlData = this.xmlData.trim();
            }
            bc.clearBody();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        Object o = this.pageContext.getAttribute(CHART_COUNT_PANAME);
        int i = 0;
        if (o != null && o instanceof Integer) {
            i = (Integer)o;
        }
        if (i == 0) {
            this.writePageInitJavaScript("com.anychart/js/AnyChart.js", "com.anychart/swf/AnyChart.swf");
        }
        this.writeComponentJavaScript("chart_" + ++i);
        this.pageContext.setAttribute(CHART_COUNT_PANAME, (Object)new Integer(i));
        return 6;
    }

    private void writePageInitJavaScript(String jsPath, String swfPath) throws JspException {
        try {
            JspWriter w = this.pageContext.getOut();
            w.print("<script type=\"text/javascript\" language=\"javascript\" src=\"");
            w.print(jsPath);
            w.print("\"></script>\n");
            w.print("<script type=\"text/javascript\" language=\"javascript\">\n//<![CDATA[\n");
            w.print("\tAnyChart.swfFile=\"");
            w.print(swfPath);
            w.print("\";\n");
            w.print("//]]>\n</script>\n");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private void writeComponentJavaScript(String jsObjectName) throws JspException {
        try {
            JspWriter w = this.pageContext.getOut();
            if (this.xmlData != null && this.xmlData.length() > 0) {
                w.print("<textarea id=\"");
                w.print(jsObjectName);
                w.print("_data\" cols=\"0\" rows=\"0\" style=\"display: none;\">\n");
                if (!this.xmlData.startsWith("<anychart")) {
                    w.print("<anychart>\n");
                }
                w.print(this.xmlData);
                if (!this.xmlData.endsWith("anychart>")) {
                    w.print("\n</anychart>\n");
                }
                w.print("</textarea>\n");
            }
            w.print("<script type=\"text/javascript\" language=\"javascript\">\n//<![CDATA[\n");
            w.print("\tvar ");
            w.print(jsObjectName);
            w.print(" = new AnyChart();\n\t");
            w.print(jsObjectName);
            w.print(".width='");
            w.print(this.width);
            w.print("';\n\t");
            w.print(jsObjectName);
            w.print(".height='");
            w.print(this.height);
            w.print("';\n");
            if (this.bgColor != null) {
                w.print("\t");
                w.print(jsObjectName);
                w.print(".bgColor='");
                w.print(this.bgColor);
                w.print("';\n");
            }
            if (this.wMode != null) {
                w.print("\t");
                w.print(jsObjectName);
                w.print(".wMode='");
                w.print(this.wMode.toString());
                w.print("';\n");
            }
            if (this.xmlFile != null) {
                w.print("\t");
                w.print(jsObjectName);
                w.print(".setXMLFile('");
                w.print(this.xmlFile);
                w.print("');\n");
            }
            if (this.xmlData != null && this.xmlData.length() > 0) {
                w.print("\t");
                w.print(jsObjectName);
                w.print(".setData(");
                w.print("document.getElementById('");
                w.print(jsObjectName);
                w.print("_data').value.toString());\n");
            }
            w.print("\t");
            w.print(jsObjectName);
            w.print(".write();\n");
            w.print("//]]>\n</script>\n");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void release() {
        this.width = null;
        this.height = null;
        this.wMode = null;
        this.bgColor = null;
        this.xmlFile = null;
        this.xmlData = null;
        super.release();
    }
}

