<%@ page contentType="text/xml; charset=UTF-8" isELIgnored ="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<sql:setDataSource driver="com.mysql.jdbc.Driver"
  url="jdbc:mysql://localhost/anychart_sample_database?useUnicode=true&amp;characterEncoding=utf8"
  user="root" password="1"/>
<anychart>
  <charts>
    <chart>
      <chart_settings>
        <title>
        <text>Products Sales Volume by Products</text>
        </title>
        <axes>
          <x_axis>
            <title>
              <text>Product Name</text>
            </title>
          </x_axis>
          <y_axis>
            <title>
              <text>Volume</text>
            </title>
            <labels>
              <format>{%Value} $</format>
            </labels>
          </y_axis>
        </axes>
      </chart_settings>
      <data_plot_settings>
        <bar_series>
          <tooltip_settings enabled="true">
            <format><![CDATA[{%Name}{enabled:false} Volume: {%YValue}$]]> </format>
          </tooltip_settings>
        </bar_series>
      </data_plot_settings>

      <data>
        <series name="Products Report">
          <sql:query var="q">
            select p.name as name, sum(o.volume) as value
              from anychart_sample_products p,
                  anychart_sample_orders o
              where p.id = o.product_id
              group by p.name
          </sql:query>
          <c:forEach var="item" items="${q.rows}">
            <point name="${item.name}" y="${item.value}" />
          </c:forEach>
        </series>
      </data>

    </chart>
  </charts>
</anychart>