package com.anychart.samples;

import java.sql.*;
import java.util.*;

/**
 * Example bean for getting data from MySQL database
 */
public class ProductReportsBean {

    /**
     * Class for store one result from query
     */
    public static class Report {
        
        private String name;
        private int value;

        /**
         * @return the name
         */
        public String getName() {
            return name;
        }

        /**
         * @return the value
         */
        public int getValue() {
            return value;
        }

    }

    private static final String url =
            "jdbc:mysql://localhost/anychart_sample_database?useUnicode=true&amp;characterEncoding=utf8";
    private static final String dbUser = "root";
    private static final String dbPass = "1";
    private static final String sqlquery =
            "select p.name as name, sum(o.volume) as value " +
                    "from anychart_sample_products p, anychart_sample_orders o " +
                    "where p.id = o.product_id group by p.name";

    public List getReportsList() throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, dbUser, dbPass);
            st = conn.createStatement();
            rs = st.executeQuery(sqlquery);
            List res = new ArrayList();
            while (rs.next()) {
                Report r = new Report();
                r.name = rs.getString("name");
                r.value = rs.getInt("value");
                res.add(r);
            }
            return res;
        } finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            } finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }
}
