<%@ page contentType="text/xml; charset=UTF-8" isELIgnored="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<jsp:useBean id="bean" class="com.anychart.samples.ProductReportsBean" />
<anychart>
  <charts>
    <chart>
      <chart_settings>
        <title>
        <text>Products Sales Volume by Products</text>
        </title>
        <axes>
          <x_axis>
            <title>
              <text>Product Name</text>
            </title>
          </x_axis>
          <y_axis>
            <title>
              <text>Volume</text>
            </title>
            <labels>
              <format>{%Value} $</format>
            </labels>
          </y_axis>
        </axes>
      </chart_settings>
      <data_plot_settings>
        <bar_series>
          <tooltip_settings enabled="true">
            <format><![CDATA[{%Name}{enabled:false} Volume: {%YValue}$]]> </format>
          </tooltip_settings>
        </bar_series>
      </data_plot_settings>

      <data>
        <series name="Products Report">
          <c:forEach var="item" items="${bean.reportsList}">
            <point name="${item.name}" y="${item.value}" />
          </c:forEach>
        </series>
      </data>

    </chart>
  </charts>
</anychart>